; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
;

[Command]
name = "cpu"
command = D, F, U, UF, D, F, x+y
time = 0

[Command]
name = "cpu2"
command = B, F, U, DB, D, F, a+b
time = 0

[Command]
name = "cpu3"
command = B, U, DB, D, F, D, c
time = 0

[Command]
name = "cpu4"
command = F, D, UB, F, B, D, a
time = 0

[Command]
name = "cpu5"
command = F+a, b+c+D, c+x+a+UB
time = 0

[Command]
name = "cpu6"
command = F+b+c, D, UB, c+a, c+x+UF
time = 0

[Command]
name = "cpu7"
command = F, U, B, F, UF, U, B, DF, c+z
time = 0

[Command]
name = "cpu8"
command = F, U, B, F, UF, U, B, DU, c+z
time = 0

[Command]
name = "cpu9"
command = F, U, B, F, UF, U, B, D, D, c+z
time = 0

[Command]
name = "cpu10"
command = F, U, B, F, UF, U, B, c+z+UB
time = 0

[Command]
name = "cpu11"
command = F, U, B, F, UF, U, B, c+z+UD
time = 0

[Command]
name = "cpu12"
command = F, U, B, F, UF, U, B, a+b
time = 0

[Command]
name = "cpu13"
command = F, U, B, F, UF, U, B, c+y
time = 0

[Command]
name = "cpu14"
command = F, U, B, F, UF, U, B, c+x
time = 0

[Command]
name = "cpu15"
command = F, U, B, F, UF, U, B, c+b
time = 0

[Command]
name = "cpu16"
command = F, U, B, F, UF, U, B, c+a
time = 0

[Command]
name = "cpu17"
command = F, U, B, F, UF, U, B, c+z+b
time = 0

[Command]
name = "cpu18"
command = F, U, B, F, UF, U, B, c+z+a
time = 0

[Command]
name = "cpu19"
command = F, U, B, F, UF, U, B, c+z+x
time = 0

[Command]
name = "cpu20"
command = F, U, B, F, UF, U, B, c+z+B
time = 0

[Command]
name = "cpu21"
command = F, U, B, F, UF, U, B, c+z+y
time = 0

[Command]
name = "cpu22"
command = F, U, B, F, UF, U, B, a+b
time = 0

[Command]
name = "cpu23"
command = F, U, B, F, UF, U, B, c+y
time = 0

[Command]
name = "cpu24"
command = F, U, B, F, UF, U, B, c+x
time = 0

[Command]
name = "cpu25"
command = F, U, B, F, UF, U, B, c+b
time = 0

[Command]
name = "cpu26"
command = F, U, B, F, UF, U, B, c+a
time = 0

[Command]
name = "cpu27"
command = F, U, B, F, UF, U, B, c+z+b
time = 0

[Command]
name = "cpu28"
command = F, U, B, F, UF, U, B, c+z+a
time = 0

[Command]
name = "cpu29"
command = F, U, B, F, UF, U, B, c+z+x
time = 0

[Command]
name = "cpu30"
command = F, U, B, F, UF, U, B, c+z+B
time = 0

[Command]
name = "cpu31"
command = F, UD, B, F, UF, U, B, c+z+y
time = 0

[Command]
name = "cpu32"
command = F, U, BD, F, UF, U, B, c+z+y
time = 0

[Command]
name = "cpu33"
command = F, UF, B, F, UF, U, B, c+z+y
time = 0

[Command]
name = "cpu34"
command = D, D, D, D, D, D, D, x
time = 1
[Command]
name = "cpu"
command = D, F, U, UF, D, F, x+y
time = 0

[Command]
name = "cpu2"
command = B, F, U, DB, D, F, a+b
time = 0

[Command]
name = "cpu3"
command = B, U, DB, D, F, D, c
time = 0

[Command]
name = "cpu4"
command = F, D, UB, F, B, D, a
time = 0

[Command]
name = "cpu5"
command = F+a, b+c+D, c+x+a+UB
time = 0

[Command]
name = "cpu6"
command = F+b+c, D, UB, c+a, c+x+UF
time = 0

[Command]
name = "cpu7"
command = F, U, B, F, UF, U, B, DF, c+z
time = 0

[Command]
name = "cpu8"
command = F, U, B, F, UF, U, B, DU, c+z
time = 0

[Command]
name = "cpu9"
command = F, U, B, F, UF, U, B, D, D, c+z
time = 0

[Command]
name = "cpu10"
command = F, U, B, F, UF, U, B, c+z+UB
time = 0

[Command]
name = "cpu11"
command = F, U, B, F, UF, U, B, c+z+UD
time = 0

[Command]
name = "cpu12"
command = F, U, B, F, UF, U, B, a+b
time = 0

[Command]
name = "cpu13"
command = F, U, B, F, UF, U, B, c+y
time = 0

[Command]
name = "cpu14"
command = F, U, B, F, UF, U, B, c+x
time = 0

[Command]
name = "cpu15"
command = F, U, B, F, UF, U, B, c+b
time = 0

[Command]
name = "cpu16"
command = F, U, B, F, UF, U, B, c+a
time = 0

[Command]
name = "cpu17"
command = F, U, B, F, UF, U, B, c+z+b
time = 0

[Command]
name = "cpu18"
command = F, U, B, F, UF, U, B, c+z+a
time = 0

[Command]
name = "cpu19"
command = F, U, B, F, UF, U, B, c+z+x
time = 0

[Command]
name = "cpu20"
command = F, U, B, F, UF, U, B, c+z+B
time = 0

[Command]
name = "cpu21"
command = F, U, B, F, UF, U, B, c+z+y
time = 0

[Command]
name = "cpu22"
command = F, U, B, F, UF, U, B, a+b
time = 0

[Command]
name = "cpu23"
command = F, U, B, F, UF, U, B, c+y
time = 0

[Command]
name = "cpu24"
command = F, U, B, F, UF, U, B, c+x
time = 0

[Command]
name = "cpu25"
command = F, U, B, F, UF, U, B, c+b
time = 0

[Command]
name = "cpu26"
command = F, U, B, F, UF, U, B, c+a
time = 0

[Command]
name = "cpu27"
command = F, U, B, F, UF, U, B, c+z+b
time = 0

[Command]
name = "cpu28"
command = F, U, B, F, UF, U, B, c+z+a
time = 0

[Command]
name = "cpu29"
command = F, U, B, F, UF, U, B, c+z+x
time = 0

[Command]
name = "cpu30"
command = F, U, B, F, UF, U, B, c+z+B
time = 0

[Command]
name = "cpu31"
command = F, UD, B, F, UF, U, B, c+z+y
time = 0

[Command]
name = "cpu32"
command = F, U, BD, F, UF, U, B, c+z+y
time = 0

[Command]
name = "cpu33"
command = F, UF, B, F, UF, U, B, c+z+y
time = 0

[Command]
name = "cpu34"
command = D, D, D, D, D, D, D, x
time = 1

;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
[Command]
name = "Omega"
command = ~D, F, a+b
time = 20

[Command]
name = "hugen" 
command = ~D, B, z
time = 20


[Command]
name = "hugen" 
command = ~D, B, z
time = 20


[Command]
name = "bokushihou"
command = ~D, D, c
time = 27

[Command]
name = "bokushihou"
command = ~D, D, c
time = 27

[Command]
name = "death"
command = ~D, D, z
time = 30

[Command]
name = "death"
command = ~D, D, z
time = 30

[Command]
name = "yamieasy"
command = z
time = 20

[Command]
name = "yawotomeMAX" 
command = ~D, F, c
time = 20

[Command]
name = "yawotomeMAX2" 
command = ~D, B, c
time = 20

[Command]
name = "yawotome" 
command = ~D, F, c
time = 20

[Command]
name = "yawotomeY" 
command = ~D, B, c
time = 20

[Command]
name = "yami"
command = ~F, D, B, F, D, B, x
time = 0

[Command]
name = "yami2"  
command = ~F, D, B, F, D, B, y
time = 0

[Command]
name = "yamiSVC"
command = ~F, D, B, F, D, B, x
time = 0

[Command]
name = "yamiSVC"
command = ~F, D, B, F, D, B, y
time = 0

[Command]
name = "giga"
command = ~D, F, x+y
time = 20

[Command]
name = "oriwaza"
command = ~D, F, D, z
time = 0

[Command]
name = "oriwaza"
command = ~D, F, D, z
time = 0

[Command]
name = "hujin" 
command = ~D, F, B, x
time = 30

[Command]
name = "hujin" 
command = ~D, F, B, y
time = 30

;-| Special Motions |------------------------------------------------------


[Command]
name = "wanx"
command = ~D, B, x

[Command]
name = "wany"
command = ~D, B, y

[Command]
name = "taiku"
command = ~D, D, x

[Command]
name = "taiku"
command = ~D, D, y

[Command]
name = "upper_xy"
command = ~D, B, x+y

[Command]
name = "kaze0"
command = ~D, F, x

[Command]
name = "kaze1"
command = ~D, F, a

[Command]
name = "kaze2"
command = ~D, F, y

[Command]
name = "kaze3"
command = ~D, F, b

[Command]
name = "aoi"
command = ~D, D, x

[Command]
name = "aoi"
command = ~D, D, y

[Command]
name = "kick"
command = ~D, D, a

[Command]
name = "kick2"
command = ~D, D, b

[Command]
name = "warpa"
command = ~D, B, a

[Command]
name = "warpb"
command = ~D, B, b

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = s
time = 10

[Command]
name = "bc"
command = a+y
time = 10

[Command]
name = "dodge"
command = x+a
time = 10

[Command]
name = "ko"
command = y+b
time = 10

[Command]
name = "ko"
command = c
time = 10

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "recovery"
command = x+a
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "holdx"
command = /$x
time = 1

[Command]
name = "holdy"
command = /$y
time = 1

[Command]
name = "holda"
command = /$a
time = 1

[Command]
name = "holdb"
command = /$b
time = 1

[Command]
name = "longjump"
command = D, $U
time = 18

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------
[State -1]
type = ChangeState
value = 7000
triggerall = command = "Omega"
triggerall = statetype != A
triggerall = power >= 3000
triggerall = var(59) = 0
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movehit = 1
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movehit = 1
trigger4 = stateno = 231
trigger4 = movehit = 1
trigger5 = stateno = 241
trigger5 = movehit = 1
trigger6 = stateno = 410
trigger6 = movehit = 1
trigger7 = stateno = 411
trigger7 = movehit = 1

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 2000
triggerall = command = "oriwaza"
triggerall = var(55) = 1
triggerall = var(58) = 0
triggerall = var(59) = 0
triggerall = statetype != A
trigger1 = life < 1
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movehit = 1
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movehit = 1
trigger4 = stateno = 231
trigger4 = movehit = 1
trigger5 = stateno = 241
trigger5 = movehit = 1
trigger6 = stateno = 410
trigger6 = movehit = 1
trigger7 = stateno = 411
trigger7 = movehit = 1

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 2000
triggerall = command = "oriwaza"
;triggerall = life <= 500
triggerall = power >= 1000
triggerall = var(59) = 0
triggerall = var(58) = 1
triggerall = statetype != A
trigger1 = life < 1
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movehit = 1
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movehit = 1
trigger4 = stateno = 231
trigger4 = movehit = 1
trigger5 = stateno = 241
trigger5 = movehit = 1
trigger6 = stateno = 410
trigger6 = movehit = 1
trigger7 = stateno = 411
trigger7 = movehit = 1

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 2000
triggerall = command = "bokushihou"
triggerall = var(59) = 0
triggerall = power >= 1000
trigger1 = ctrl
triggerall = statetype != A
trigger2 = stateno = 201
trigger2 = movehit = 1
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movehit = 1
trigger4 = stateno = 231
trigger4 = movehit = 1
trigger5 = stateno = 241
trigger5 = movehit = 1
trigger6 = stateno = 410
trigger6 = movehit = 1
trigger7 = stateno = 411
trigger7 = movehit = 1

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 2100
triggerall = command = "giga"
triggerall = power >= 1000
triggerall = var(58) = 1
triggerall = var(59) = 0
triggerall = statetype != A
;trigger1 = life < 1
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movehit = 1
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movehit = 1
trigger4 = stateno = 231
trigger4 = movehit = 1
trigger5 = stateno = 241
trigger5 = movehit = 1
trigger6 = stateno = 410
trigger6 = movehit = 1
trigger7 = stateno = 411
trigger7 = movehit = 1

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 2120
triggerall = command = "giga"
triggerall = var(58) = 0
;߿޿  ܴ  svc
triggerall = var(59) = 0
triggerall = statetype != A
;trigger1 = life < 1
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movehit = 1
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movehit = 1
trigger4 = stateno = 231
trigger4 = movehit = 1
trigger5 = stateno = 241
trigger5 = movehit = 1
trigger6 = stateno = 410
trigger6 = movehit = 1
trigger7 = stateno = 411
trigger7 = movehit = 1

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 2200
triggerall = command = "death"
triggerall = power >= 1000
triggerall = var(59) = 0
trigger1 = ctrl
triggerall = statetype != A
trigger2 = stateno = 201
trigger2 = movehit = 1
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movehit = 1
trigger4 = stateno = 231
trigger4 = movehit = 1
trigger5 = stateno = 241
trigger5 = movehit = 1
trigger6 = stateno = 410
trigger6 = movehit = 1
trigger7 = stateno = 411
trigger7 = movehit = 1

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1010
triggerall = command = "yami"
triggerall = var(58) = 1
triggerall = var(59) = 0
triggerall = statetype != A
triggerall = p2bodydist x  < 50
triggerall = p2statetype != A
triggerall = p2stateno != 150
triggerall = p2stateno != 152
triggerall = p2stateno != 154
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movehit = 1
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movehit = 1
trigger4 = stateno = 231
trigger4 = movehit = 1
trigger5 = stateno = 241
trigger5 = movehit = 1
trigger6 = stateno = 410
trigger6 = movehit = 1
trigger7 = stateno = 411
trigger7 = movehit = 1

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1009
triggerall = command = "yami2"
triggerall = p2statetype != A
triggerall = var(58) = 1
triggerall = var(59) = 0
triggerall = statetype != A
triggerall = p2bodydist x  < 50
triggerall = p2stateno != 150
triggerall = p2stateno != 152
triggerall = p2stateno != 154
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movehit = 1
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movehit = 1
trigger4 = stateno = 231
trigger4 = movehit = 1
trigger5 = stateno = 241
trigger5 = movehit = 1
trigger6 = stateno = 410
trigger6 = movehit = 1
trigger7 = stateno = 411
trigger7 = movehit = 1


[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1120
triggerall = command = "yamieasy"
triggerall = var(58) = 1
triggerall = statetype != A
triggerall = p2bodydist x  < 50
triggerall = p2statetype != A
triggerall = p2stateno != 150
triggerall = p2stateno != 152
triggerall = p2stateno != 154
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movehit = 1
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movehit = 1
trigger4 = stateno = 231
trigger4 = movehit = 1
trigger5 = stateno = 241
trigger5 = movehit = 1
trigger6 = stateno = 410
trigger6 = movehit = 1
trigger7 = stateno = 411
trigger7 = movehit = 1

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1400
triggerall = command = "yamiSVC" || command = "yamieasy"
triggerall = power >= 1000
triggerall = statetype != A
triggerall = var(58) = 0
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact


[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1300
triggerall = command = "yawotomeMAX"
triggerall = life <= 500
triggerall = power >= 1000
triggerall = statetype = s
triggerall = var(58) = 1
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1800
triggerall = command = "yawotomeMAX2" ;Y
triggerall = life <= 500
triggerall = power >= 1000
triggerall = statetype = s
triggerall = var(58) = 1
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1700
triggerall = command = "yawotomeMAX" ;svc
triggerall = statetype = s
triggerall = var(58) = 0
triggerall = var(57) = 1
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1720
triggerall = command = "yawotomeY" ;svc
triggerall = statetype = s
triggerall = var(58) = 0
triggerall = var(57) = 1
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1030
triggerall = command = "yawotome"
triggerall = statetype = s
triggerall = var(58) = 1
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1050
triggerall = command = "yawotomeY"
triggerall = statetype = s
triggerall = var(58) = 1
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1200
triggerall = command = "hujin"
triggerall = power >= 1000
triggerall = var(59) = 0
triggerall = statetype != A
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1500
triggerall = command = "hugen"
triggerall = var(58) = 0
triggerall = var(59) = 0
triggerall = statetype != A
triggerall = var(56) = 1
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1500
triggerall = command = "hugen"
triggerall = var(58) = 1
triggerall = var(59) = 0
triggerall = statetype != A
triggerall = power >= 1000
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact
;---------------------------------------------------------------------------
[State -1, Light Kung Fu Palm]
type = ChangeState
value = 1600
triggerall = command = "wanx"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Light Kung Fu Palm]
type = ChangeState
value = 1601
triggerall = command = "wany"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Light Kung Fu Palm]
type = ChangeState
value = 2030
triggerall = command = "taiku"
triggerall = var(58) = 0
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Light Kung Fu Palm]
type = ChangeState
value = 2330
triggerall = command = "taiku"
triggerall = var(58) = 1
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Light Kung Fu Palm]
type = ChangeState
value = 1000
triggerall = command = "kaze0"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Strong Kung Fu Palm]
type = ChangeState
value = 1001
triggerall = command = "kaze1"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Strong Kung Fu Palm]
type = ChangeState
value = 1002
triggerall = command = "kaze2"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Strong Kung Fu Palm]
type = ChangeState
value = 1003
triggerall = command = "kaze3"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Strong Kung Fu Palm]
type = ChangeState
value = 1060
triggerall = command = "aoi"
trigger1 = statetype != A
trigger1 = ctrl
triggerall = var(58) = 0
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Strong Kung Fu Palm]
type = ChangeState
value = 1061
triggerall = command = "aoi"
trigger1 = stateno = 1060
triggerall = var(58) = 0
trigger1 = animelem = 6, >= 1

[State -1, Strong Kung Fu Palm]
type = ChangeState
value = 1062
triggerall = command = "aoi"
triggerall = var(58) = 0
trigger1 = animelem = 5, >= 1
trigger1 = stateno = 1061

;;taiku

[State -1, Strong Kung Fu Palm]
type = ChangeState
value = 2310
triggerall = command = "kick"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Strong Kung Fu Palm]
type = ChangeState
value = 2320
triggerall = command = "kick2"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Strong Kung Fu Palm]
type = ChangeState
value = 1410
triggerall = command = "warpa"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

[State -1, Strong Kung Fu Palm]
type = ChangeState
value = 1420
triggerall = command = "warpb"
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = stateno = 201
trigger2 = movecontact
trigger3 = stateno = 211&& animelem = 4, <= 4
trigger3 = movecontact
trigger4 = stateno = 231
trigger4 = movecontact
trigger5 = stateno = 241
trigger5 = movecontact
trigger6 = stateno = 410
trigger6 = movecontact
trigger7 = stateno = 411
trigger7 = movecontact

;---------------------------------------------------------------------------

;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
;?bV
[State -1, Run Fwd]
type = ChangeState
value = 100
triggerall = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = var(58) = 1

;Run Fwd
;?bV
[State -1, Run Fwd]
type = ChangeState
value = 102
triggerall = command = "FF"
trigger1 = statetype != A
trigger1 = ctrl
trigger1 = var(58) = 0

;Run Fwd
;?bV
[State -1, Run Fwd]
type = ChangeState
value = 104
triggerall = command = "FF" || command = "bc"
trigger1 = statetype != A
trigger1 = (stateno = 150 || stateno = 151) && power >= 500
trigger1 = var(58) = 0

;---------------------------------------------------------------------------
;Run Back
;?bV
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;CSVC
[State -1, Kung Fu Throw]
;trigger1 = power >= 5000
type = ChangeState
value = 810
triggerall = command = "y"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
triggerall = var(58) = 0
trigger1 = command = "holdfwd"
trigger1 = p2bodydist x  < 5
trigger1 = (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist x  < 5
trigger2 = (p2statetype = C)
trigger2 = p2movetype != H

;C96
[State -1, Kung Fu Throw]
;trigger1 = power >= 5000
type = ChangeState
value = 840
triggerall = command = "y"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
triggerall = var(58) = 1
trigger1 = command = "holdfwd"
trigger1 = p2bodydist x  < 5
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist x  < 5
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H

;D
[State -1, Kung Fu Throw]
;trigger1 = power >= 5000
type = ChangeState
value = 815
triggerall = command = "b"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist x  < 5
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist x  < 5
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H


;?O
[State -1]
;trigger1 = power >= 5000
type = ChangeState
value = 900
triggerall = var(59) = 0
triggerall = var(58) = 1
triggerall = command = "dodge"
triggerall = command != "holdback"
trigger1 = statetype != A && (ctrl || stateno = 100)
;trigger1 = power >= 5000
trigger2 = (stateno = 150 || stateno = 151) && power >= 500

;?
[State -1]
;trigger1 = power >= 5000
type = ChangeState
value = 910
triggerall = var(59) = 0
triggerall = var(58) = 1
triggerall = command = "dodge"
triggerall = command = "holdback"
trigger1 = statetype != A && (ctrl || stateno = 100)
;trigger1 = power >= 5000
trigger2 = (stateno = 150 || stateno = 151) && power >= 500

;===========================================================================
;ӂ΂
[State -1, Standing Strong Kick]
type = ChangeState
value = 242
triggerall = command = "ko"
triggerall = var(59) = 0
triggerall = var(58) = 1
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 150 || stateno = 151) && power >= 500

;ӂ΂SVC
[State -1, Standing Strong Kick]
type = ChangeState
value = 243
triggerall = command = "ko"
triggerall = var(59) = 0
triggerall = var(58) = 0
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = (stateno = 150 || stateno = 151) && power >= 500

;---------------------------------------------------------------------------
;Stand Light Punch
;p?
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = var(59) = 0
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = p2bodydist x > 20

;Stand Light Punch
;p?
[State -1, Stand Light Punch]
type = ChangeState
value = 201
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = var(59) = 0
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = p2bodydist x <= 20
;---------------------------------------------------------------------------
;Stand Strong Punch
;p?
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
triggerall = var(59) = 0
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = p2bodydist x > 20

;---------------------------------------------------------------------------
;Stand Strong Punch
;ߋp?
[State -1, Stand Strong Punch]
type = ChangeState
value = 211
triggerall = command = "y"
triggerall = command != "holddown"
triggerall = var(59) = 0
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = p2bodydist x  <= 20

;---------------------------------------------------------------------------
;Stand Light Kick
;LbN
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = var(59) = 0
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = p2bodydist x  > 20

;Stand Light Kick
;LbN
[State -1, Stand Light Kick]
type = ChangeState
value = 231
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = var(59) = 0
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = p2bodydist x  <= 20

;---------------------------------------------------------------------------
;Standing Strong Kick
;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 4477
triggerall = command = "b"
triggerall = command != "holddown"
;triggerall = Statetype!= A
triggerall = var(58) = 0
triggerall = var(59) = 0
trigger1 = statetype = S
trigger1 = ctrl

;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 4477
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = var(58) = 1
triggerall = var(59) = 0
trigger1 = statetype = S
trigger1 = ctrl

;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 4477
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = var(58) = 0
triggerall = var(59) = 0
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = p2bodydist x  <= 20
;trigger1 = life < 1

;---------------------------------------------------------------------------
;Taunt
;
[State -2, Taunt]
type = ChangeState
value = 1710
triggerall = command = "start"
triggerall = power < 3000
triggerall = var(59) = 0
triggerall = statetype = S
;trigger1 = p2statetype != S
;trigger1 = p2bodydist x > 100
trigger1 = ctrl

;---------------------------------------------------------------------------
;Taunt
;
[State -2, Taunt]
type = ChangeState
value = 1711
triggerall = command = "start"
triggerall = var(59) = 0
;triggerall = power >= 3000
trigger1 = stateno = 1710

;---------------------------------------------------------------------------
;Crouching Light Punch
;Ⴊݎp?
[State -1, Crouching Light Punch]
type = ChangeState
value = 410
triggerall = command = "x"
triggerall = command = "holddown"
triggerall = var(59) = 0
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Strong Punch
;Ⴊ݋p?
[State -1, Crouching Strong Punch]
type = ChangeState
value = 411
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = var(59) = 0
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Kick
;ႪݎLbN
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
triggerall = var(59) = 0
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Strong Kick
;Ⴊ݋LbN
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
triggerall = var(59) = 0
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;ӂ΂
[State -1, Standing Strong Kick]
type = ChangeState
value = 510
triggerall = command = "ko" || command = "c"
triggerall = var(59) = 0
triggerall = var(58) = 1
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Light Punch
;Wvp?
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
triggerall = var(59) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger1 = Vel X != 0

;Jump Light Punch
;Wvp?
[State -1, Jump Light Punch]
type = ChangeState
value = 601
triggerall = command = "x"
triggerall = var(59) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger1 = Vel X = 0
;---------------------------------------------------------------------------
;Wvp?
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
triggerall = var(59) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger1 = Vel X != 0

;Wvp?
[State -1, Jump Strong Punch]
type = ChangeState
value = 611
triggerall = command = "y"
triggerall = var(59) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger1 = Vel X = 0

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
triggerall = var(59) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger1 = Vel X != 0

;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 631
triggerall = command = "a"
triggerall = var(59) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger1 = Vel X = 0

;---------------------------------------------------------------------------
;Jump Strong Kick
;󒆋LbN
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = command = "b"
triggerall = var(59) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger1 = Vel X != 0

;Jump Strong Kick
;󒆋LbN
[State -1, Jump Strong Kick]
type = ChangeState
value = 641
triggerall = command = "b"
triggerall = var(59) = 0
trigger1 = statetype = A
trigger1 = ctrl
trigger1 = Vel X = 0

